<%@ Page Language="C#" MasterPageFile="~/usrManager.master" AutoEventWireup="true" Inherits="Profiles_Profile_AddProf" Title="Untitled Page" Codebehind="AddProf.aspx.cs" %>
<asp:Content ID="oContent" ContentPlaceHolderID="oBody" Runat="Server">
  <script language="javascript" type="text/javascript">
    //<![CDATA[
    var szPlus = "<% = Page.ResolveUrl("~/Images/Plus.gif") %>";
    var szMinus = "<% = Page.ResolveUrl("~/Images/Minus.gif") %>";

    // Modifica el estado de los checkbox de una Organizacion (Marca todo o Desmarca todo)
    // Parameters:
    //            1. sender = CheckBox que produjo la llamada
    //            2. pOrgId = Id de la Organizacion a la cual pertenece el Check
    function CheckUnCheckAll(sender, pOrgId)
    {
      var objInputs;
      var objInput;

      // Search on all Input Tags.
      objInputs = document.getElementsByTagName('input');
      
      for (var i = 0; i < objInputs.length; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if (objInput.type == 'checkbox')
        {       
          if (objInput.parentNode.getAttribute('organizationId') != null && objInput.parentNode.getAttribute('organizationId') == pOrgId)
            objInput.checked = sender.checked;
          if (objInput.getAttribute('organizationId') != null && objInput.getAttribute('organizationId') == pOrgId)
            objInput.checked = sender.checked;
        }
      }
    }
    
    
    // Modifica el estado de los checkbox de una grilla (MarcarTodos/DesmarcarTodos/Invertir) contenida dentro de otra
    // Parameters:
    //            1. pAction = {'UNCHECKALL', 'CHECKALL', 'REVERSE'}
    //            2. pChkCategory = Categoria a la cual pertenece el check (su propiedad 'category')
    function ChangeStatusCheckBoxComplex(pAction, pChkCategory)
    {
      var objInputs;
      var objInput;

      // Search on all Input Tags.
      objInputs = document.getElementsByTagName('input');

      switch (pAction.toUpperCase())
      {
        case "UNCHECKALL":
          for (var i = 0; i < objInputs.length; i++)
          {
            // Get Input that acts as a Filter
            objInput = objInputs.item(i);
            if (objInput.type == 'checkbox')
            {
              if (objInput.parentNode.getAttribute('category') != null && (objInput.parentNode.getAttribute('category') == pChkCategory || objInput.parentNode.getAttribute('category') == 'Header'))
                objInput.checked = false;
              if (objInput.getAttribute('category') != null && (objInput.getAttribute('category') == pChkCategory || objInput.getAttribute('category') == 'Header'))
                objInput.checked = false;
            }
          }
          break;
        case "CHECKALL":
          for (var i = 0; i < objInputs.length; i++)
          {
            // Get Input that acts as a Filter
            objInput = objInputs.item(i);
            if (objInput.type == 'checkbox')
            {
              if (objInput.parentNode.getAttribute('category') != null && (objInput.parentNode.getAttribute('category') == pChkCategory || objInput.parentNode.getAttribute('category') == 'Header'))
                objInput.checked = true;
              if (objInput.getAttribute('category') != null && (objInput.getAttribute('category') == pChkCategory || objInput.getAttribute('category') == 'Header'))
                objInput.checked = true;
            }
          }
          break;
        case "REVERSE":
          for (var i = 0; i < objInputs.length; i++)
          {
            // Get Input that acts as a Filter
            objInput = objInputs.item(i);
            if (objInput.type == 'checkbox')
            {
              if (objInput.parentNode.getAttribute('category') != null && objInput.parentNode.getAttribute('category') == pChkCategory)
                objInput.checked = !objInput.checked;
              if (objInput.getAttribute('category') != null && objInput.getAttribute('category') == pChkCategory)
                objInput.checked = !objInput.checked;
              if (objInput.parentNode.getAttribute('category') != null && objInput.parentNode.getAttribute('category') == 'Header')
                objInput.checked = false;
              if (objInput.getAttribute('category') != null && objInput.getAttribute('category') == 'Header')
                objInput.checked = false;
            }
          }
          break;
      }

      return false; //para que no me ejecute el evento click del servidor
    }
    
    // Oculto/Muestro el iframe
    function ShowHideOrgChart(strElement)
    {
      var objElement;
      
      if (document.getElementById(strElement) != null)
      {
        objElement = document.getElementById(strElement);
        if (objElement.style.display == 'none')
          objElement.style.display = '';
        else
          objElement.style.display = 'none';
      }
      objElement = null;
    }
    
    // Autosize del iframe que contiene el organigrama
    function calcLocalHeight(strIFrameName)
    {
      var intHeight;
      var oIFrame;

      intHeight = 800;

      //Procesamiento del script
      try
      {
        oIFrame = window.document.getElementsByName(strIFrameName)[0]; //obtengo el iFrame de la pagina local
        intHeight = oIFrame.contentWindow.document.body.scrollHeight; //obtengo el alto de la pagina a abrir en el iFrame
        oIFrame.height = parseInt(intHeight); //cambio el alto del iFrame
      }
      catch(e)
      {}
      finally
      {
        intHeight = null;
        oIFrame = null;
      }
    }
    //]]>
  </script>
  <script language="javascript" type="text/javascript" src="<% = Page.ResolveUrl("~/Includes/CollapsablePanels.js") %>"></script>
  <script language="javascript" type="text/javascript" src="../../Includes/JS_Functions.js" enableviewstate="false"></script>
  <!-- Logo de Pectra y Seccion Agregar Perfil -->
  <table border="0" cellpadding="0" cellspacing="0" class="tblTitle">
    <tr>
      <td class="SecTitle">
        <img alt="" class="PectraLogo<% = ((Request.ServerVariables["HTTP_USER_AGENT"].IndexOf("MSIE") > -1) ? "IE": "").ToString() %>"
          src="<% = Page.ResolveUrl(string.Format("~/Images/PectraLogo.{0}.png", Page.Theme)) %>" />
        <span id="spanProf" runat="server">
          Perfil
        </span>
      </td>
    </tr>
  </table>
  
  <!-- Separador -->
  <hr class="Separator" />
  
  <!-- Panel de Filtro -->
  <asp:Panel ID="pnlFilter" CssClass="Filter" runat="server" Width="100%" EnableViewState="False">
    <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
      <tr>
        <td id="tdFilterCaption" class="FilterCaption">
          <img id="img1" src="../../Images/Profile16.gif" class="Filter" />
          <span id="spanAddProf" runat="server">Agregar Perfil</span>
        </td>
      </tr>
      <tr>
        <td id="tdContent" class="FilterContent" colspan="2">
          <table border="0" cellpadding="0" cellspacing="1" style="width: 100%;">
            <tr>
              <td class="Caption" align="right">
                <span id="spanProfId" runat="server">Id de Perfil</span>:&nbsp;
              </td>
              <td>
                <asp:TextBox ID="txtProfId" SkinID="Filter" runat="server" MaxLength="250" EnableViewState="False"></asp:TextBox>
              </td>
            </tr>
            <tr>
              <td class="Caption" align="right">
                <span id="spanDescription" runat="server">Descripci&oacute;n</span>:&nbsp;
              </td>
              <td>
                <asp:TextBox ID="txtProfDescription" SkinID="Filter" runat="server" MaxLength="250" EnableViewState="False"></asp:TextBox>
              </td>
            </tr>
            <tr>
              <td class="Caption" align="right">
                <span id="spanOrganizationalProf" runat="server">Perfil Organizacional</span>:&nbsp;
              </td>
              <td>
                <asp:CheckBox ID="chkOrganizationalProf" runat="server" Checked="false" EnableViewState="false" />
              </td>
            </tr>
            <tr>
              <td class="Caption" align="right">
                <span id="spanReportTo" runat="server">Reporta a</span>:&nbsp;
              </td>
              <td>
                <asp:DropDownList ID="ddlReportTo" runat="server" SkinID="Filter" Enabled="false" EnableViewState="true"></asp:DropDownList>
                <asp:Button ID="btnChart" runat="server" SkinID="Filter" Text="Organigrama" OnClientClick="javascript:ShowHideOrgChart('trChart');calcLocalHeight('iFrameOrgChart');return false;" />
              </td>
            </tr>
            <!-- Organigrama -->
            <tr id="trChart" style="display: none;">
              <td colspan="2">
                <iframe id="iFrameOrgChart" name="iFrameOrgChart" src="ProfOrgChartImage.aspx" runat="server" scrolling="auto" marginheight="0" marginwidth="0" frameborder="0" enableviewstate="false" width="100%" height="100%"></iframe>
              </td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
    
    <br />
    <hr class="Separator" />
    <table border="0" cellpadding="0" cellspacing="0" style="width: 100%">
      <!-- Botones de confirmacion (son los mismos que los de final de pagina)-->
      <tr>
        <td align="right">
          <asp:Button ID="btnOk1" runat="server" SkinID="Filter" Text="Aceptar" OnClick="btnOk_Click" />
          <asp:Button ID="btnCancel1" runat="server" SkinID="Filter" Text="Cancelar" />
        </td>
      </tr>
    </table>

    <hr class="Separator" />
    <br />
    
    <!-- Grilla de Unidades Operacionales disponibles para asignar -->
    <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
      <tr>
        <td class="FilterCaption">
          <asp:Image ID="img5" runat="server" ImageUrl="~/Images/UoOrgs16.gif" ImageAlign="AbsMiddle" />
          <span id="spanUosTitle" runat="server">
            Asignar Unidades Operacionales
          </span>
        </td>
        <td class="FilterOptions">
          <asp:Button SkinID="Filter" ID="btnUnCheckAllUos" runat="server" Text="Desmarcar Todo" EnableViewState="true" />
          <asp:Button SkinID="Filter" ID="btnCheckAllUos" runat="server" Text="Marcar Todo" EnableViewState="true" />
          <asp:Button SkinID="Filter" ID="btnReverseUos" runat="server" Text="Invertir" EnableViewState="true" />
        </td>
      </tr>
    </table>
    <!-- Filtro -->
    <asp:Panel ID="pnlFilter2" CssClass="Filter" runat="server" Width="100%">
      <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
        <tr>
          <td id="tdFilterContent3" class="FilterCaption">
            <a href="javascript:showPanel('tdFilterContent', 'img', szPlus, szMinus);"
              class="Filter">
              <img id="img" alt="Mostrar/Ocultar Filtro" src="<%= Page.ResolveUrl("~/Images/Plus.gif") %>"
                class="Filter" />
              <span id="spanFilter" runat="server">
                Filtro
              </span>
            </a>
          </td>
          <td class="FilterOptions">
            <asp:Button SkinID="Filter" ID="btnAplicarFiltro" runat="server" Text="Aplicar Filtro" OnClick="btnAplicarFiltro_Click" />
            <asp:Button SkinID="Filter" ID="btnRefrescar" runat="server" Text="Refrescar" OnClick="btnRefrescar_Click" />
          </td>
        </tr>
        <tr>
          <td id="tdFilterContent" class="FilterContent" colspan="2" style="display: <%= ViewState["DisplayFilter"].ToString()%>;" >
            <table border="0" cellpadding="0" cellspacing="1" style="width: 100%;">
              <tr>
                <td class="Caption">
                  &nbsp;<span id="spanOrgId" runat="server">Id de Organizacin</span>:
                </td>
                <td>
                  <asp:TextBox ID="txtOrgId" SkinID="Filter" runat="server" MaxLength="50" EnableViewState="False"></asp:TextBox>
                </td>
              </tr>
              <tr>
                <td class="Caption">
                  &nbsp;<span id="spanOrgDescription" runat="server">Descripci&oacute;n de Organizacin</span>:
                </td>
                <td>
                  <asp:TextBox ID="txtOrgDescription" SkinID="Filter" runat="server" MaxLength="255" EnableViewState="False"></asp:TextBox>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </asp:Panel>
    <!-- Grilla Padre -->
    <table border="0" cellpadding="0" cellspacing="0" style="width: 100%">
      <tr>
        <td>
          <div class="Filter">
            <asp:GridView ID="gridOrg" runat="server" AutoGenerateColumns="False" DataKeyNames="OrgId"
                          SkinID="Filter" AllowPaging="True"
                          OnDataBound="gridOrg_DataBound" OnRowCreated="gridOrg_RowCreated" OnPageIndexChanging="gridOrg_PageIndexChanging">
              <PagerSettings FirstPageImageUrl="~/Images/NavFirstPage.gif" FirstPageText="First"
                             LastPageImageUrl="~/Images/NavLastPage.gif" LastPageText="Last"
                             Mode="NumericFirstLast" />
              <Columns>
                <asp:BoundField DataField="OrgId" HeaderText="Id de Organizacion" HeaderStyle-CssClass="AutoSize" ItemStyle-CssClass="AutoSize">
                </asp:BoundField>
                <asp:BoundField ReadOnly="True" DataField="OrgDescription" HeaderText="Descripci&#243;n de Organizacin" HeaderStyle-CssClass="AutoSize" ItemStyle-CssClass="AutoSize">
                </asp:BoundField>
                <asp:TemplateField HeaderText="Unidades Operacionales">
                  <ItemStyle Width="60%" HorizontalAlign="Left"></ItemStyle>
                  <ItemTemplate>
                    <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
                      <tr>
                        <td id="td2" class="">
                          <a href="javascript:showPanel('tdFilterContentChild<%# Eval("OrgId") %>', 'img<%# Eval("OrgId") %>', szPlus, szMinus);"
                            class="Filter">
                            <img id="img<%# Eval("OrgId") %>" alt="Mostrar/Ocultar Filtro" src="<%= Page.ResolveUrl("~/Images/Plus.gif") %>"
                              class="Filter" />
                          </a>
                        </td>
                      </tr>
                      <tr>
                        <td id="tdFilterContentChild<%# Eval("OrgId") %>" class="" colspan="2" style="display:none" >
                          <!-- GridView Child -->
                          <asp:GridView ID="gridChild" runat="server" AutoGenerateColumns="False" DataKeyNames="UoId" AllowPaging="false" AllowSorting="false"
                                        SkinID="FilterChild" OnRowCreated="gridChild_RowCreated" OnDataBound="gridChild_DataBound" DataSource='<%# Bind("OperationalUnitsCollection") %>'>
                            <Columns>
                              <asp:BoundField DataField="UoId" SortExpression="UoId" HeaderText="Operational Unit Id" HeaderStyle-HorizontalAlign="Center">
                                <ItemStyle Width="40%" HorizontalAlign="Left"></ItemStyle>
                              </asp:BoundField>
                              <asp:BoundField ReadOnly="True" DataField="UoDescription" SortExpression="UoDescription" HeaderText="Descripci&#243;n" HeaderStyle-HorizontalAlign="Center">
                                <ItemStyle Width="40%" HorizontalAlign="Left" Wrap="False"></ItemStyle>
                              </asp:BoundField>   
                              <asp:TemplateField HeaderText="Asignar" HeaderStyle-HorizontalAlign="Center" HeaderStyle-CssClass="AutoSize" ItemStyle-CssClass="AutoSize">
                                <ItemStyle HorizontalAlign="Center"></ItemStyle>
                                  <ItemTemplate>
                                    <input type="checkbox" id="chkGridUo" category="OperationalUnit" organizationId="" orgIdUoId="" runat="server" enableviewstate="false" />
                                </ItemTemplate>
                              </asp:TemplateField>
                              <asp:TemplateField HeaderText="Defecto" HeaderStyle-HorizontalAlign="Center" HeaderStyle-CssClass="AutoSize" ItemStyle-CssClass="AutoSize">
                                <ItemStyle HorizontalAlign="Center"></ItemStyle>
                                  <ItemTemplate>
                                    <input type="radio" id="rdoGridUo" category="OperationalUnit" orgIdUoId="" onclick="javascript:CheckOneUnCheckAllRadio(this, 'OperationalUnit');CheckOne(this);" runat="server" enableviewstate="false" />
                                  </ItemTemplate>
                              </asp:TemplateField>
                            </Columns>
                          </asp:GridView>
                        </td>
                      </tr>
                    </table>

                  </ItemTemplate>
                </asp:TemplateField>
              </Columns>
            </asp:GridView>
            <!-- Informacion de cantidad y pagina -->
            <div class="Filter" id="divPaging" runat="server" visible="true">
              <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
                <tr>
                  <td id="td1" class="FilterCaption" style="width: 50%">
                    <b><span id="spanInformation" runat="server">Informaci&oacute;n</span>: </b><span id="spanPageOnetoOne" runat="server">P&aacute;gina 1 de 1</span>&nbsp;|&nbsp;<b><span id="spanCount" runat="server">Cantidad</span>: </b><%=ViewState["RowsCount"]%> <span id="spanUosPaging" runat="server">unidades operacionales</span>
                  </td>
                </tr>
              </table>
            </div>
            <br />            
          </div>
        </td>
      </tr>
    </table>
    <!-- Botones de Confirmacion de Pie de Pagina -->
    <table border="0" cellpadding="0" cellspacing="0" style="width: 100%">
      <tr>
        <td align="right">
          <hr class="Separator" />
          <asp:Button ID="btnOk2" runat="server" SkinID="Filter" Text="Aceptar" OnClick="btnOk_Click" />
          <asp:Button ID="btnCancel2" runat="server" SkinID="Filter" Text="Cancelar" />
          <hr class="Separator" />
          <br />
        </td>
      </tr>
    </table>

  </asp:Panel>
</asp:Content>

